#ifndef VIEW_H
#define VIEW_H

// Common functions for rat views

void DebugView(float *view);

// Check if two view vectors are equal. Returns true if views same.
// Returns false if views different.
bool ViewsEqual(float *view1, float *view2);

// Copy view2 to view1. view1 must be previously allocated.
// view2 ownership is retained by caller.
void CopyView(float *view1, float *view2);

// Subtract two vectors and then compute the vector length of the result.
// Computes || v1 - v2 ||.
double VectorDistance(float* v1, float* v2);

// Returns the number of elements in the intersection of the two views
// considered as sets.
int NumberSharedElements(float* v1, float* v2);

#endif